/******************************************************************************
 * @file: CAmLogger.h
 *
 * This file contains the declaration of functions used for logging purpose
 *
 * @component: AudioManager Generic Controller
 *
 * @author: Toshiaki Isogai <tisogai@jp.adit-jv.com>
 *          Kapildev Patel  <kpatel@jp.adit-jv.com>
 *          Prashant Jain   <pjain@jp.adit-jv.com>
 *
 * @copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *****************************************************************************/

#ifndef GC_LOGGER_H_
#define GC_LOGGER_H_

#include "IAmControlCommon.h"

#define GC_CONTEXT_STRING "AMCO"
#define GC_CONTEXT_DESCRIPTION "DLT Context for AMCO"

namespace am {
namespace gc {

static am::IAmLogContext &GenericControllerLogger = am::CAmLogWrapper::instance()->registerContext(GC_CONTEXT_STRING, GC_CONTEXT_DESCRIPTION);

#define LOG_DEBUG_DEFAULT_VALUE 4

/**
 * logs a given value with error level with the default context
 * @param ...
 */
template <typename ...Args> void CAmLogDebug(Args... args)
{
    GenericControllerLogger.debug(args...);
}

/*
 * Helper functions to log
 */
template <typename ...Args> inline void LOG_FN_ENTRY(Args... args)
{
    CAmLogDebug(">> ", args...);
}

template <typename ...Args> inline void LOG_FN_EXIT(Args... args)
{
    CAmLogDebug("<<", args...);
}

template <typename ...Args> inline void LOG_FN_DEBUG(Args... args)
{
    GenericControllerLogger.debug(args...);
}

/**
 * logs a given value with warning level with the default context
 * @param ...
 */
template <typename ...Args> inline void LOG_FN_WARN(Args... args)
{
    GenericControllerLogger.warn(args...);
}

/**
 * logs a given value with error level with the default context
 * @param ...
 */
template <typename ...Args> inline void LOG_FN_ERROR(Args... args)
{
    GenericControllerLogger.error(args...);
}

/**
 * logs a given value with infolevel with the default context
 * @param ...
 */
template <typename ...Args> inline void LOG_FN_INFO(Args... args)
{
    GenericControllerLogger.info(args...);
}

inline void LOG_FN_CHANGE_LEVEL(const am_LogLevel_e loglevel)
{
    GenericControllerLogger = am::CAmLogWrapper::instance()->registerContext(GC_CONTEXT_STRING, GC_CONTEXT_DESCRIPTION, loglevel, LS_ON);
}

} /* namespace gc */
} /* namespace am */
#endif /* GC_LOGGER_H_ */
